![image](teaser.png)

# 1.2.0
#### Meet the new version of Hashcore Toolkit!

We've made it even more convenient and efficient. Now you can group devices, receive notifications about new releases, and quickly import groups. We've also added a custom device display mode, support for the Antminer S21 XP Hydro and Antminer S21XP Imm, and much more!

#### **New features:**

- Device Grouping and Statistics: Organize your miners into groups and get separate statistics for each group for more effective monitoring and analysis. Use "jumps" between groups for easier navigation.
- **New Version Notifications:** Stay up-to-date with the latest releases! Download updates directly from the app or snooze them for later. A handy tag at the bottom of the app will alert you when a new version is available.
- **Customizable Device Display:** Enjoy a new level of flexibility! Combine data from metrics mode and pool mode to view your miner information exactly how you want it.
- **Antminer S21 XP Hydro and Antminer S21XP Imm Support:** We've expanded our hardware compatibility.
- **"Find Miner" Command:** Quickly locate specific miners within your farm using the new "Find Miner" command for Bitmain (Antminer Stock) firmware.
- **Braiins and Luxor Firmware Statistics:** Get detailed statistics for miners running Braiins and Luxor firmware.
- **DevFee Display and Issue Alerts:** Monitor DevFee and receive alerts about any related issues.
- **Chinese Localization:** We've added Chinese language support to make our app accessible to a wider audience.
- **Build Name Display:** Easily identify the specific build version you are running.
- **Firebase Analytics:** We've implemented Firebase analytics to help us identify and fix bugs faster, improving the app's stability and your experience.
- **"About Us" Section:** Want to learn more about our team and products? Simply tap on the app logo to access the new "About Us" section.
- **New `toolkit_cli` Commands:** We've added the `clone` and `reset-autotune` commands to `toolkit_cli` for advanced users.

#### **Improvements:**

- **Effortless Group Import:** Simply drag and drop your file into the application. Hashcore Toolkit will automatically detect the file type, display its statistics, and guide you in selecting the correct format. Importing your miners has never been easier!
- **Support in Your Language:** We've expanded our support services to assist you in multiple languages. Get the help you need in the language you prefer.
- **Optimized Device Addition During Network Scanning:** Enjoy a faster and more efficient experience when adding devices through network scanning.
- **Improved Worker Sorting:** Sorting workers is now more intuitive! Names with different letter cases are grouped together for better organization.
- **Firmware Installation Overhaul:** We've streamlined the firmware installation process for a smoother and more user-friendly experience.
- **Interface Enhancements:** We've widened the firmware version column for increased readability, updated the appearance of tooltips, and improved the list display in pool mode for clearer presentation.
- **Quick Access to Group Range Export:** The export function is now more prominently located, providing faster access to this essential operation.
- **Export Single Group from Network Group Context Menu:** You can now conveniently export a single group directly from the network group context menu.

#### **Fixes:** 

- **Fixed Windows Startup Freeze:** Resolved an issue where Windows would freeze on startup if window position data was lost.
- **Prevented Application Data Loss:** Fixed a bug that could cause the loss of application data. Recovery files are now saved reliably.
- **Resolved Thread Blocking:** Addressed an issue that caused thread blocking when launching Rust-based handlers.
- **Improved "Rescan" Button Behavior:** Modified the behavior of the Rescan button in the device list for a smoother experience.
- **Enhanced `toolkit_cli` Functionality:** Fixed several issues and improved the overall functionality of the `toolkit_cli`.
- **"Install Firmware" Task Fix:** Resolved a bug that prevented the "Install Firmware" task from launching correctly.
- **Mac UI and Description Updates:** Corrected control labels and improved the application description for Mac users.
- And made a bunch of other minor tweaks…

### 1.1.0
- Presets for filters and sorting
- Added device filtering and sorting by subnets
- Added firmware reset operation
- Support for Antminer S19j XP and S19e XP Hydro
- Device "Offline" display mode
- Russian language localization
- Multi-level menu headers
- Labels for unlock types
- Responsiveness: Added some responsiveness to the application for small device screens
- Operations window: extended information, filtering, deleting, stopping operations
- Device context menu
- Search and monitoring algorithms
- Warnings and labels for unlock types
- Device cloning feature
- Application interface
- Improved filter selection
- Quick access to device list export
- Fixed issue with canceling user passwords
- Fixed automatic removal of spaces in firmware file names
- Fixed error exporting and importing network groups for Windows
- Ended support for Windows 8 and older versions

### 1.0.2
- Fixed an issue that caused the launch to fail on Windows 11

### 1.0.1
- Fixed timeout issue when saving the network list
- Minor interface adjustments
- Added data validation in the Firmware Installation and Firmware Update dialogs (checks for empty firmware name and version)
- Added group power consumption
- Updated file name generation for exporting files. The imported file name is now used as the group name
- Implemented password saving for a range in the unlock dialog for a single miner
- Fixed issue with ignoring model parameters during firmware updates
- Fixed pool mode artifact
- Windows 7 and 8 support will be discontinued in future versions

### 1.0.0
- Initial release of the application